---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-Job Artifacts Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/ci/job_artifacts/track_artifact_report_service.rb` (行6-23)
- E-02: 帳票一覧.csv (No.20の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 内部イベントトラッキング形式 | E-01 (行7) | ○ |
| C-02 | REPORT_TRACKEDで追跡対象定義 | E-01 (行8) | ○ |
| C-03 | :testと:coverageを追跡 | E-01 (行8) | ○ |
| C-04 | executeがエントリーポイント | E-01 (行10) | ○ |
| C-05 | REPORT_TRACKEDをループ | E-01 (行11) | ○ |
| C-06 | complete_and_has_reports?でチェック | E-01 (行12) | ○ |
| C-07 | of_report_type(report)でフィルタ | E-01 (行12) | ○ |
| C-08 | track_usage_eventで記録 | E-01 (行13) | ○ |
| C-09 | event_name(report)でイベント名生成 | E-01 (行13, 17-19) | ○ |
| C-10 | pipeline.user_idを渡す | E-01 (行13) | ○ |
| C-11 | i_testing_{report}_report_uploaded形式 | E-01 (行18) | ○ |
| C-12 | Gitlab::Utils::UsageDataをinclude | E-01 (行7) | ○ |
| C-13 | パイプライン完了時に実行 | E-01 (構造から推測), E-02 | ○ |
| C-14 | 2種類のレポートを追跡 | E-01 (行8) | ○ |
| C-15 | ユーザーIDのみを記録 | E-01 (行13) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠あり、コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] パイプライン完了時にサービスが呼び出されることを確認
- [ ] テストレポート存在時にi_testing_test_report_uploadedイベントが記録されることを確認
- [ ] カバレッジレポート存在時にi_testing_coverage_report_uploadedイベントが記録されることを確認
- [ ] ユーザーIDが正しく渡されることを確認
